/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.util;

import java.io.IOException;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.rank.Median;
import org.apache.iotdb.library.util.NoNumberException;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.type.Type;
import org.eclipse.collections.api.tuple.primitive.LongIntPair;
import org.eclipse.collections.impl.map.mutable.primitive.LongIntHashMap;

public class Util {
    private Util() {
        throw new IllegalStateException("Utility class");
    }

    public static double getValueAsDouble(Row row, int index) throws IOException, NoNumberException {
        double ans = 0.0;
        try {
            switch (row.getDataType(index)) {
                case INT32: {
                    ans = row.getInt(index);
                    break;
                }
                case INT64: {
                    ans = row.getLong(index);
                    break;
                }
                case FLOAT: {
                    ans = row.getFloat(index);
                    break;
                }
                case DOUBLE: {
                    ans = row.getDouble(index);
                    break;
                }
                default: {
                    throw new NoNumberException();
                }
            }
        }
        catch (IOException e) {
            throw new IOException("Fail to get data type in row " + row.getTime(), e);
        }
        return ans;
    }

    public static double getValueAsDouble(Row row) throws IOException, NoNumberException {
        return Util.getValueAsDouble(row, 0);
    }

    public static Object getValueAsObject(Row row) throws IOException {
        Object ans = 0;
        switch (row.getDataType(0)) {
            case INT32: {
                ans = row.getInt(0);
                break;
            }
            case INT64: {
                ans = row.getLong(0);
                break;
            }
            case FLOAT: {
                ans = Float.valueOf(row.getFloat(0));
                break;
            }
            case DOUBLE: {
                ans = row.getDouble(0);
                break;
            }
            case BOOLEAN: {
                ans = row.getBoolean(0);
                break;
            }
            case TEXT: {
                ans = row.getString(0);
                break;
            }
        }
        return ans;
    }

    public static void putValue(PointCollector pc, Type type, long t, Object o) throws IOException {
        switch (type) {
            case INT32: {
                pc.putInt(t, ((Integer)o).intValue());
                break;
            }
            case INT64: {
                pc.putLong(t, ((Long)o).longValue());
                break;
            }
            case FLOAT: {
                pc.putFloat(t, ((Float)o).floatValue());
                break;
            }
            case DOUBLE: {
                pc.putDouble(t, ((Double)o).doubleValue());
                break;
            }
            case BOOLEAN: {
                pc.putBoolean(t, ((Boolean)o).booleanValue());
                break;
            }
        }
    }

    public static double[] toDoubleArray(List<Double> list) {
        return list.stream().mapToDouble(Double::valueOf).toArray();
    }

    public static long[] toLongArray(List<Long> list) {
        return list.stream().mapToLong(Long::valueOf).toArray();
    }

    public static double mad(double[] value) {
        Median median = new Median();
        double mid = median.evaluate(value);
        double[] d = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            d[i] = Math.abs(value[i] - mid);
        }
        return 1.4826 * median.evaluate(d);
    }

    public static double[] variation(double[] origin) {
        int n = origin.length;
        double[] variance = new double[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            variance[i] = origin[i + 1] - origin[i];
        }
        return variance;
    }

    public static double[] variation(long[] origin) {
        int n = origin.length;
        double[] variance = new double[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            variance[i] = origin[i + 1] - origin[i];
        }
        return variance;
    }

    public static int[] variation(int[] origin) {
        int n = origin.length;
        int[] variance = new int[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            variance[i] = origin[i + 1] - origin[i];
        }
        return variance;
    }

    public static double[] speed(double[] origin, double[] time) {
        int n = origin.length;
        double[] speed = new double[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            speed[i] = (origin[i + 1] - origin[i]) / (time[i + 1] - time[i]);
        }
        return speed;
    }

    public static double[] speed(double[] origin, long[] time) {
        int n = origin.length;
        double[] speed = new double[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            speed[i] = (origin[i + 1] - origin[i]) / (double)(time[i + 1] - time[i]);
        }
        return speed;
    }

    public static long mode(long[] values) {
        LongIntHashMap map = new LongIntHashMap();
        for (long v : values) {
            map.addToValue(v, 1);
        }
        long key = 0L;
        int maxValue = 0;
        for (LongIntPair p : map.keyValuesView()) {
            if (p.getTwo() <= maxValue) continue;
            key = p.getOne();
            maxValue = p.getTwo();
        }
        return key;
    }

    public static long parseTime(String s) {
        long unit = 0L;
        s = s.toLowerCase();
        if ((s = s.replace(" ", "")).endsWith("ms")) {
            unit = 1L;
            s = s.substring(0, s.length() - 2);
        } else if (s.endsWith("s")) {
            unit = 1000L;
            s = s.substring(0, s.length() - 1);
        } else if (s.endsWith("m")) {
            unit = 60000L;
            s = s.substring(0, s.length() - 1);
        } else if (s.endsWith("h")) {
            unit = 3600000L;
            s = s.substring(0, s.length() - 1);
        } else if (s.endsWith("d")) {
            unit = 86400000L;
            s = s.substring(0, s.length() - 1);
        }
        double v = Double.parseDouble(s);
        return (long)((double)unit * v);
    }
}

