/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.string;

import java.io.IOException;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.MappableRowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.utils.Binary;

public class UDTFRegexSplit
implements UDTF {
    private String regex;
    private int index;

    public void beforeStart(UDFParameters udfParameters, UDTFConfigurations udtfConfigurations) throws Exception {
        this.regex = udfParameters.getString("regex");
        this.index = udfParameters.getIntOrDefault("index", -1);
        udtfConfigurations.setAccessStrategy((AccessStrategy)new MappableRowByRowAccessStrategy());
        if (this.index == -1) {
            udtfConfigurations.setOutputDataType(Type.INT32);
        } else {
            udtfConfigurations.setOutputDataType(Type.TEXT);
        }
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        String[] splitResult = row.getString(0).split(this.regex);
        if (this.index == -1) {
            collector.putInt(row.getTime(), splitResult.length);
        } else if (this.index < splitResult.length) {
            collector.putString(row.getTime(), splitResult[this.index]);
        }
    }

    public Object transform(Row row) throws IOException {
        if (row.isNull(0)) {
            return null;
        }
        String str = row.getString(0);
        String[] splitResult = str.split(this.regex);
        if (this.index == -1) {
            return splitResult.length;
        }
        if (this.index < splitResult.length) {
            return splitResult[this.index];
        }
        return null;
    }

    public void transform(Column[] columns, ColumnBuilder builder) throws Exception {
        Binary[] inputs = columns[0].getBinaries();
        boolean[] isNulls = columns[0].isNull();
        int count = columns[0].getPositionCount();
        if (this.index == -1) {
            for (int i = 0; i < count; ++i) {
                if (isNulls[i]) {
                    builder.appendNull();
                    continue;
                }
                String str = inputs[i].toString();
                String[] splitResult = str.split(this.regex);
                builder.writeInt(splitResult.length);
            }
        } else {
            for (int i = 0; i < count; ++i) {
                if (isNulls[i]) {
                    builder.appendNull();
                    continue;
                }
                String str = inputs[i].toString();
                String[] splitResult = str.split(this.regex);
                if (this.index < splitResult.length) {
                    builder.writeBinary(new Binary(splitResult[this.index].getBytes()));
                    continue;
                }
                builder.appendNull();
            }
        }
    }

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.TEXT).validate(regex -> ((String)regex).length() > 0, "regexp has to be a valid regular expression.", (Object)validator.getParameters().getStringOrDefault("regex", "")).validate(index -> (Integer)index >= -1, "index must a non-negative integer to fetch split results or -1 to get length.", (Object)validator.getParameters().getIntOrDefault("index", -1));
    }
}

