/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.series.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;

public class ConsecutiveUtil {
    private static final int MAX_LEN = 128;
    private long first;
    private long last;
    private long gap;
    private int count = 0;
    private final List<Pair<Long, Boolean>> window = new ArrayList<Pair<Long, Boolean>>(128);

    public ConsecutiveUtil(long first, long last, long gap) {
        this.first = first;
        this.last = last;
        this.gap = gap;
    }

    public List<Pair<Long, Boolean>> getWindow() {
        return this.window;
    }

    public long getGap() {
        return this.gap;
    }

    public void setGap(long gap) {
        this.gap = gap;
    }

    public int getMaxLen() {
        return 128;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public long getFirst() {
        return this.first;
    }

    public void setFirst(long first) {
        this.first = first;
    }

    public long getLast() {
        return this.last;
    }

    public boolean check(Row row) throws IOException {
        for (int i = 0; i < row.size(); ++i) {
            if (!row.isNull(i)) continue;
            return true;
        }
        return false;
    }

    public void calculateGap() {
        long[] time = new long[this.window.size() - 1];
        for (int i = 0; i < time.length; ++i) {
            time[i] = (Long)this.window.get(i + 1).getLeft() - (Long)this.window.get(i).getLeft();
        }
        this.gap = Util.mode(time);
    }

    public void cleanWindow(PointCollector collector) throws IOException {
        if (this.window.isEmpty()) {
            return;
        }
        this.first = this.last = -this.gap;
        for (Pair<Long, Boolean> p : this.window) {
            this.process((Long)p.getLeft(), (Boolean)p.getRight(), collector);
        }
    }

    public void process(long time, boolean nullExist, PointCollector collector) throws IOException {
        if (nullExist) {
            if (this.count > 1) {
                collector.putInt(this.first, this.count);
            }
            this.first = this.last = -this.gap;
            this.count = 0;
        } else if (time == this.last + this.gap) {
            this.last = time;
            ++this.count;
        } else {
            if (this.count > 1) {
                collector.putInt(this.first, this.count);
            }
            this.first = this.last = time;
            this.count = 1;
        }
    }
}

