/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.series;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.iotdb.library.series.util.ConsecutiveUtil;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFConsecutiveSequences
implements UDTF {
    private ConsecutiveUtil consUtil;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validate(x -> (Long)x > 0L, "gap should be a time period whose unit is ms, s, m, h.", (Object)Util.parseTime(validator.getParameters().getStringOrDefault("gap", "1ms")));
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy()).setOutputDataType(Type.INT32);
        long gap = Util.parseTime(parameters.getStringOrDefault("gap", "0ms"));
        this.consUtil = new ConsecutiveUtil(-gap, -gap, gap);
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        if (this.consUtil.getGap() == 0L) {
            if (this.consUtil.getWindow().size() < this.consUtil.getMaxLen()) {
                this.consUtil.getWindow().add((Pair<Long, Boolean>)Pair.of((Object)row.getTime(), (Object)this.consUtil.check(row)));
            } else {
                this.consUtil.calculateGap();
                this.consUtil.cleanWindow(collector);
            }
        } else {
            this.consUtil.process(row.getTime(), this.consUtil.check(row), collector);
        }
    }

    public void terminate(PointCollector collector) throws Exception {
        if (this.consUtil.getGap() == 0L) {
            this.consUtil.calculateGap();
            this.consUtil.cleanWindow(collector);
        }
        if (this.consUtil.getCount() > 1) {
            collector.putInt(this.consUtil.getFirst(), this.consUtil.getCount());
        }
    }
}

