/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.match.model;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.iotdb.library.match.model.DTWMatchResult;
import org.apache.iotdb.udf.api.State;

public class DTWState
implements State {
    private List<DTWMatchResult> matchResults;
    private Deque<Double> valueBuffer;
    private Deque<Long> timeBuffer;
    private Integer size;

    public DTWState() {
    }

    public DTWState(int size) {
        this.size = size;
    }

    public void reset() {
        this.matchResults = new ArrayList<DTWMatchResult>();
        this.valueBuffer = new ArrayDeque<Double>(this.size);
        this.timeBuffer = new ArrayDeque<Long>(this.size);
    }

    public byte[] serialize() {
        int capacity = 8 + this.valueBuffer.size() * 16 + this.matchResults.size() * 20;
        ByteBuffer byteBuffer = ByteBuffer.allocate(capacity);
        byteBuffer.putInt(this.valueBuffer.size());
        Object[] times = this.timeBuffer.toArray();
        Object[] values = this.valueBuffer.toArray();
        for (int i = 0; i < this.timeBuffer.size(); ++i) {
            byteBuffer.putLong((Long)times[i]);
            byteBuffer.putDouble((Double)values[i]);
        }
        byteBuffer.putInt(this.matchResults.size());
        for (DTWMatchResult matchResult : this.matchResults) {
            byteBuffer.put(matchResult.toByteArray());
        }
        return byteBuffer.array();
    }

    public void deserialize(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        int size = byteBuffer.getInt();
        for (int i = 0; i < size; ++i) {
            this.updateBuffer(byteBuffer.getLong(), byteBuffer.getDouble());
        }
        int resultSize = byteBuffer.getInt();
        for (int i = 0; i < resultSize; ++i) {
            byte[] dst = new byte[20];
            byteBuffer.get(dst);
            this.matchResults.add(DTWMatchResult.fromByteArray(dst));
        }
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Integer getSize() {
        return this.size;
    }

    public void updateBuffer(long time, double dataPoint) {
        if (this.valueBuffer.size() == this.size.intValue()) {
            this.valueBuffer.poll();
            this.timeBuffer.poll();
        }
        this.timeBuffer.offer(time);
        this.valueBuffer.offer(dataPoint);
    }

    public Double[] getValueBuffer() {
        return this.valueBuffer.toArray(new Double[0]);
    }

    public Long[] getTimeBuffer() {
        return this.timeBuffer.toArray(new Long[0]);
    }

    public long getFirstTime() {
        return this.timeBuffer.getFirst();
    }

    public long getLastTime() {
        return this.timeBuffer.getLast();
    }

    public void destroyState() {
        this.valueBuffer.clear();
        super.destroyState();
    }

    public void addMatchResult(DTWMatchResult matchResult) {
        this.matchResults.add(matchResult);
    }

    public List<DTWMatchResult> getMatchResults() {
        return this.matchResults;
    }

    public static void main(String[] args) {
        int i;
        DTWState state = new DTWState();
        state.setSize(5);
        state.reset();
        for (i = 0; i < 4; ++i) {
            state.updateBuffer(i, i);
            state.addMatchResult(new DTWMatchResult(i, i, i));
        }
        for (i = 0; i < state.getTimeBuffer().length; ++i) {
            System.out.println(state.getTimeBuffer()[i] + " " + state.getValueBuffer()[i]);
        }
        for (DTWMatchResult matchResult : state.matchResults) {
            System.out.println(matchResult);
        }
        DTWState newState = new DTWState();
        newState.setSize(5);
        newState.reset();
        newState.deserialize(state.serialize());
        for (int i2 = 0; i2 < state.getTimeBuffer().length; ++i2) {
            System.out.println(state.getTimeBuffer()[i2] + " " + state.getValueBuffer()[i2]);
        }
        System.out.println(newState.getMatchResults());
    }
}

