/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.match;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.library.match.PatternExecutor;
import org.apache.iotdb.library.match.UDAFDTWMatch;
import org.apache.iotdb.library.match.model.DTWMatchResult;
import org.apache.iotdb.library.match.model.PatternContext;
import org.apache.iotdb.library.match.model.PatternResult;
import org.apache.iotdb.library.match.model.PatternState;
import org.apache.iotdb.library.match.model.Point;
import org.apache.iotdb.udf.api.State;
import org.apache.iotdb.udf.api.UDAF;
import org.apache.iotdb.udf.api.customizer.config.UDAFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.iotdb.udf.api.utils.ResultValue;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;

public class UDAFPatternMatch
implements UDAF {
    private Long[] timePattern;
    private Double[] valuePattern;
    private float threshold;
    private PatternState state;

    public void beforeStart(UDFParameters udfParameters, UDAFConfigurations udafConfigurations) {
        udafConfigurations.setOutputDataType(Type.TEXT);
        Map attributes = udfParameters.getAttributes();
        this.threshold = !attributes.containsKey("threshold") ? 100.0f : Float.parseFloat((String)attributes.get("threshold"));
        this.timePattern = (Long[])Arrays.stream(((String)attributes.get("timePattern")).split(",")).map(Long::valueOf).toArray(Long[]::new);
        this.valuePattern = (Double[])Arrays.stream(((String)attributes.get("valuePattern")).split(",")).map(Double::valueOf).toArray(Double[]::new);
    }

    public State createState() {
        this.state = new PatternState();
        return this.state;
    }

    public void addInput(State state, Column[] columns, BitMap bitMap) {
        PatternState matchState = (PatternState)state;
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || columns[1].isNull(i)) continue;
            long timestamp = columns[1].getLong(i);
            double value = this.getValue(columns[0], i);
            matchState.updateBuffer(timestamp, value);
        }
    }

    public void combineState(State state, State state1) {
        PatternState matchState = (PatternState)state;
        PatternState newMatchState = (PatternState)state1;
        List<Long> times = newMatchState.getTimeBuffer();
        List<Double> values = newMatchState.getValueBuffer();
        for (int i = 0; i < times.size(); ++i) {
            matchState.updateBuffer(times.get(i), values.get(i));
        }
    }

    public void outputFinal(State state, ResultValue resultValue) {
        PatternState matchState = (PatternState)state;
        PatternExecutor executor = new PatternExecutor();
        List<Point> sourcePointsExtract = executor.scalePoint(matchState.getTimeBuffer(), matchState.getValueBuffer());
        List<Point> queryPointsExtract = executor.extractPoints(this.timePattern, this.valuePattern);
        executor.setPoints(queryPointsExtract);
        PatternContext ctx = new PatternContext();
        ctx.setThreshold(this.threshold);
        ctx.setDataPoints(sourcePointsExtract);
        List<PatternResult> results = executor.executeQuery(ctx);
        if (!results.isEmpty()) {
            resultValue.setBinary(new Binary(results.toString(), Charset.defaultCharset()));
        } else {
            UDAFDTWMatch dtw = new UDAFDTWMatch();
            List<DTWMatchResult> dtwMatchResult = dtw.calcMatch(matchState.getTimeBuffer(), matchState.getValueBuffer(), this.valuePattern, this.threshold);
            if (!dtwMatchResult.isEmpty()) {
                resultValue.setBinary(new Binary(dtwMatchResult.toString(), Charset.defaultCharset()));
            } else {
                resultValue.setNull();
            }
        }
    }

    public void validate(UDFParameterValidator validator) {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE, Type.BOOLEAN}).validateRequiredAttribute("timePattern").validateRequiredAttribute("valuePattern").validateRequiredAttribute("threshold");
    }

    private double getValue(Column column, int i) {
        switch (column.getDataType()) {
            case INT32: {
                return column.getInt(i);
            }
            case INT64: {
                return column.getLong(i);
            }
            case FLOAT: {
                return column.getFloat(i);
            }
            case DOUBLE: {
                return column.getDouble(i);
            }
            case BOOLEAN: {
                return column.getBoolean(i) ? 1.0 : 0.0;
            }
        }
        throw new RuntimeException(String.format("Unsupported datatype %s", column.getDataType()));
    }
}

