/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.frequency;

import java.text.SimpleDateFormat;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.jtransforms.fft.DoubleFFT_1D;

public class UDTFIFFT
implements UDTF {
    private static final String START_PARAM = "start";
    private final DoubleArrayList real = new DoubleArrayList();
    private final DoubleArrayList imag = new DoubleArrayList();
    private final IntArrayList time = new IntArrayList();
    private long start;
    private long interval;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(2).validateInputSeriesDataType(0, new Type[]{Type.DOUBLE, Type.FLOAT, Type.INT32, Type.INT64}).validate(x -> (Long)x > 0L, "interval should be a time period whose unit is ms, s, m, h, d.", (Object)Util.parseTime(validator.getParameters().getStringOrDefault("interval", "1s")));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (validator.getParameters().hasAttribute(START_PARAM)) {
            validator.validate(x -> (Long)x > 0L, "start should conform to the format yyyy-MM-dd HH:mm:ss.", (Object)format.parse(validator.getParameters().getString(START_PARAM)).getTime());
        }
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        this.interval = Util.parseTime(parameters.getStringOrDefault("interval", "1s"));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.start = 0L;
        if (parameters.hasAttribute(START_PARAM)) {
            this.start = format.parse(parameters.getString(START_PARAM)).getTime();
        }
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        if (!row.isNull(0) && !row.isNull(1) && Double.isFinite(Util.getValueAsDouble(row, 0)) && Double.isFinite(Util.getValueAsDouble(row, 1))) {
            this.time.add((int)row.getTime());
            this.real.add(Util.getValueAsDouble(row, 0));
            this.imag.add(Util.getValueAsDouble(row, 1));
        }
    }

    public void terminate(PointCollector collector) throws Exception {
        int n = this.time.get(this.time.size() - 1) + 1;
        double[] a = new double[n * 2];
        for (int i = 0; i < this.time.size(); ++i) {
            int k = this.time.get(i);
            a[k * 2] = this.real.get(i);
            a[k * 2 + 1] = this.imag.get(i);
            if (k <= 0) continue;
            k = n - k;
            a[k * 2] = this.real.get(i);
            a[k * 2 + 1] = -this.imag.get(i);
        }
        DoubleFFT_1D fft = new DoubleFFT_1D((long)n);
        fft.complexInverse(a, true);
        for (int i = 0; i < n; ++i) {
            collector.putDouble(this.start + (long)i * this.interval, a[2 * i]);
        }
    }
}

