/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.frequency;

import java.util.ArrayList;
import org.apache.iotdb.library.frequency.util.DWTUtil;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFIDWT
implements UDTF {
    private ArrayList<Long> timestamp = new ArrayList();
    private ArrayList<Double> value = new ArrayList();
    private String s;
    private String method;
    private int layer;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesDataType(0, new Type[]{Type.DOUBLE, Type.FLOAT, Type.INT32, Type.INT64}).validate(x -> ((String)x).equalsIgnoreCase("Haar") || ((String)x).equalsIgnoreCase("DB2") || ((String)x).equalsIgnoreCase("DB4") || ((String)x).equalsIgnoreCase("DB6") || ((String)x).equalsIgnoreCase("DB8") || ((String)x).equalsIgnoreCase(""), "Method not supported, please input coefficient and leave method blank.", (Object)validator.getParameters().getStringOrDefault("method", "")).validate(x -> (Integer)x > 0, "layer has to be a positive integer.", (Object)validator.getParameters().getIntOrDefault("layer", 1));
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        this.s = parameters.getStringOrDefault("coef", "");
        this.method = parameters.getStringOrDefault("method", "");
        this.layer = parameters.getIntOrDefault("layer", 1);
        this.timestamp.clear();
        this.value.clear();
    }

    public void transform(Row row, PointCollector pointCollector) throws Exception {
        this.timestamp.add(row.getTime());
        this.value.add(Util.getValueAsDouble(row));
    }

    public void terminate(PointCollector pointCollector) throws Exception {
        if (!this.s.equals("") || !this.method.equals("")) {
            DWTUtil transformer = new DWTUtil(this.method, this.s, this.layer, this.value);
            transformer.inverse();
            double[] r = transformer.getData();
            for (int i = 0; i < r.length; ++i) {
                pointCollector.putDouble(this.timestamp.get(i).longValue(), r[i]);
            }
        }
    }
}

