/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.frequency;

import org.apache.iotdb.library.frequency.util.FFTUtil;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.jtransforms.fft.DoubleFFT_1D;

public class UDTFFFT
implements UDTF {
    private static final String COMPRESS_PARAM = "compress";
    private boolean compressed;
    private FFTUtil fftutil;
    private final DoubleArrayList list = new DoubleArrayList();

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.DOUBLE, Type.FLOAT, Type.INT32, Type.INT64}).validate(x -> ((String)x).equalsIgnoreCase("uniform") || ((String)x).equalsIgnoreCase("nonuniform"), "Type should be 'uniform' or 'nonuniform'.", (Object)validator.getParameters().getStringOrDefault("method", "uniform")).validate(x -> "real".equalsIgnoreCase((String)x) || "imag".equalsIgnoreCase((String)x) || "abs".equalsIgnoreCase((String)x) || "angle".equalsIgnoreCase((String)x), "Result should be 'real', 'imag', 'abs' or 'angle'.", (Object)validator.getParameters().getStringOrDefault("result", "abs")).validate(x -> (Double)x > 0.0 && (Double)x <= 1.0, "Compress should be within (0,1].", (Object)validator.getParameters().getDoubleOrDefault(COMPRESS_PARAM, 1.0));
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        String result = parameters.getStringOrDefault("result", "abs");
        this.compressed = parameters.hasAttribute(COMPRESS_PARAM);
        double compressRate = parameters.getDoubleOrDefault(COMPRESS_PARAM, 1.0);
        this.fftutil = new FFTUtil(result, compressRate);
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        double v = Util.getValueAsDouble(row);
        if (Double.isFinite(v)) {
            this.list.add(v);
        }
    }

    public void terminate(PointCollector collector) throws Exception {
        int n = this.list.size();
        DoubleFFT_1D fft = new DoubleFFT_1D((long)n);
        double[] a = new double[2 * n];
        for (int i = 0; i < n; ++i) {
            a[2 * i] = this.list.get(i);
            a[2 * i + 1] = 0.0;
        }
        fft.complexForward(a);
        if (this.compressed) {
            this.fftutil.outputCompressed(collector, a);
        } else {
            this.fftutil.outputUncompressed(collector, a);
        }
    }
}

