/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.frequency;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.math3.complex.Complex;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFOutputSeriesDataTypeNotValidException;
import org.apache.iotdb.udf.api.type.Type;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.jtransforms.fft.DoubleFFT_1D;

public class UDFEnvelopeAnalysis
implements UDTF {
    private double frequency;
    private int amplification;
    private String timestampPrecision;
    private final DoubleArrayList signals = new DoubleArrayList();
    private final LongArrayList timestamps = new LongArrayList();
    private static final String TIMESTAMP_PRECISION = "timestampPrecision";
    private static final String FREQUENCY = "frequency";
    private static final String AMPLIFICATION = "amplification";
    public static final String MS_PRECISION = "ms";
    public static final String US_PRECISION = "us";
    public static final String NS_PRECISION = "ns";

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.DOUBLE, Type.FLOAT, Type.INT32, Type.INT64}).validate(x -> (Double)x > 0.0, "The param 'frequency' must > 0.", (Object)validator.getParameters().getDoubleOrDefault(FREQUENCY, Double.MAX_VALUE)).validate(x -> (Integer)x >= 1, "The param 'amplification' must >= 1.", (Object)validator.getParameters().getIntOrDefault(AMPLIFICATION, 1));
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        this.frequency = parameters.getDoubleOrDefault(FREQUENCY, Double.MAX_VALUE);
        this.amplification = parameters.getIntOrDefault(AMPLIFICATION, 1);
        this.timestampPrecision = parameters.getSystemStringOrDefault(TIMESTAMP_PRECISION, MS_PRECISION);
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        this.signals.add(this.getValueAsDouble(row, 0));
        if (this.timestamps.size() < 10) {
            this.timestamps.add(row.getTime());
        }
    }

    public void terminate(PointCollector collector) throws Exception {
        int i;
        double[] envelopeValues = this.envelopeAnalyze(this.signals.toArray());
        this.frequency = this.frequency != Double.MAX_VALUE ? this.frequency : this.calculateFrequency(this.timestamps);
        int signalSize = this.signals.size();
        double[] frequencies = new double[signalSize / 2];
        for (i = 0; i < signalSize / 2; ++i) {
            frequencies[i] = (double)i * (this.frequency * (double)this.amplification / (double)signalSize);
        }
        for (i = 0; i < envelopeValues.length; ++i) {
            collector.putDouble((long)frequencies[i], envelopeValues[i]);
        }
    }

    public double[] envelopeAnalyze(double[] signals) {
        Complex[] hilbertTransformed = this.calculateHilbert(signals);
        double[] hilbertAbs = this.calculateAbs(hilbertTransformed);
        double[] fftTransformed = this.calculateFFT(hilbertAbs);
        return this.calculateEnvelope(signals.length, fftTransformed);
    }

    public Complex[] calculateHilbert(double[] timeDomainSignal) {
        int signalSize = timeDomainSignal.length;
        DoubleFFT_1D fftTransformer = new DoubleFFT_1D((long)signalSize);
        double[] frequencyDomainValues = new double[signalSize * 2];
        System.arraycopy(timeDomainSignal, 0, frequencyDomainValues, 0, signalSize);
        fftTransformer.realForwardFull(frequencyDomainValues);
        double[] hilbertFilter = new double[signalSize];
        if (signalSize % 2 == 0) {
            hilbertFilter[signalSize / 2] = 1.0;
            hilbertFilter[0] = 1.0;
            Arrays.fill(hilbertFilter, 1, signalSize / 2, 2.0);
        } else {
            hilbertFilter[0] = 1.0;
            Arrays.fill(hilbertFilter, 1, (signalSize + 1) / 2, 2.0);
        }
        for (int i = 0; i < signalSize; ++i) {
            int n = 2 * i;
            frequencyDomainValues[n] = frequencyDomainValues[n] * hilbertFilter[i];
            int n2 = 2 * i + 1;
            frequencyDomainValues[n2] = frequencyDomainValues[n2] * hilbertFilter[i];
        }
        fftTransformer.complexInverse(frequencyDomainValues, true);
        Complex[] analyticSignals = new Complex[signalSize];
        for (int i = 0; i < signalSize; ++i) {
            analyticSignals[i] = new Complex(frequencyDomainValues[2 * i], frequencyDomainValues[2 * i + 1]);
        }
        return analyticSignals;
    }

    private double[] calculateAbs(Complex[] complexNumbers) {
        double[] magnitudes = new double[complexNumbers.length];
        for (int i = 0; i < complexNumbers.length; ++i) {
            magnitudes[i] = complexNumbers[i].abs();
        }
        return magnitudes;
    }

    private double[] calculateFFT(double[] realValues) {
        DoubleFFT_1D fftTransformer = new DoubleFFT_1D((long)realValues.length);
        double[] fftComplex = new double[realValues.length * 2];
        System.arraycopy(realValues, 0, fftComplex, 0, realValues.length);
        fftTransformer.realForwardFull(fftComplex);
        return fftComplex;
    }

    private double[] calculateEnvelope(int originalLength, double[] fftValues) {
        double[] envelope = new double[originalLength / 2];
        for (int i = 0; i < envelope.length; ++i) {
            int realIndex = 2 * i;
            int imagIndex = realIndex + 1;
            envelope[i] = Math.sqrt(fftValues[realIndex] * fftValues[realIndex] + fftValues[imagIndex] * fftValues[imagIndex]) / (double)originalLength;
        }
        return envelope;
    }

    public double calculateFrequency(LongArrayList timestamps) {
        LongArrayList timeDifferences = this.calculateTimeDifferences(timestamps);
        long modeTimeDifference = this.calculateMode(timeDifferences);
        return UDFEnvelopeAnalysis.calculateFrequencyByTimeUnit(modeTimeDifference, this.timestampPrecision);
    }

    public LongArrayList calculateTimeDifferences(LongArrayList timestamps) {
        LongArrayList timeDifferences = new LongArrayList();
        for (int i = 1; i < timestamps.size(); ++i) {
            timeDifferences.add(timestamps.get(i) - timestamps.get(i - 1));
        }
        return timeDifferences;
    }

    public long calculateMode(LongArrayList timestamps) {
        HashMap<Long, Integer> countMap = new HashMap<Long, Integer>();
        int maxCount = 0;
        long modeTimeDifference = 0L;
        for (long diff : timestamps.toArray()) {
            int count = countMap.getOrDefault(diff, 0) + 1;
            countMap.put(diff, count);
            if (count <= maxCount) continue;
            maxCount = count;
            modeTimeDifference = diff;
        }
        return modeTimeDifference;
    }

    public double getValueAsDouble(Row row, int index) throws IOException {
        double ans;
        switch (row.getDataType(index)) {
            case INT32: {
                ans = row.getInt(index);
                break;
            }
            case INT64: {
                ans = row.getLong(index);
                break;
            }
            case FLOAT: {
                ans = row.getFloat(index);
                break;
            }
            case DOUBLE: {
                ans = row.getDouble(index);
                break;
            }
            default: {
                throw new UDFOutputSeriesDataTypeNotValidException(index, "Fail to get data type in row " + row.getTime());
            }
        }
        return ans;
    }

    public static double calculateFrequencyByTimeUnit(long time, String timeUnit) {
        switch (timeUnit) {
            case "ms": {
                return 1000.0 / (double)time;
            }
            case "us": {
                return 1000000.0 / (double)time;
            }
            case "ns": {
                return 1.0E9 / (double)time;
            }
        }
        throw new IllegalArgumentException("Unsupported time unit.");
    }
}

