/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.drepair.util;

import org.apache.iotdb.library.drepair.util.ValueFill;
import org.apache.iotdb.udf.api.access.RowIterator;

public class LinearFill
extends ValueFill {
    private int prevNotNaN = -1;

    public LinearFill(RowIterator dataIterator) throws Exception {
        super(dataIterator);
    }

    @Override
    public void fill() {
        for (int i = 0; i < this.original.length; ++i) {
            if (Double.isNaN(this.original[i])) continue;
            double k = 0.0;
            if (this.prevNotNaN > 0) {
                k = this.original[i] - this.original[this.prevNotNaN];
                k /= (double)(i - this.prevNotNaN);
            }
            for (int t = this.prevNotNaN + 1; t < i; ++t) {
                this.repaired[t] = this.original[i] + k * (double)(t - i);
            }
            this.repaired[i] = this.original[i];
            this.prevNotNaN = i;
        }
        if (this.prevNotNaN < this.original.length - 1 && this.prevNotNaN >= 0) {
            for (int t = this.prevNotNaN; t <= this.original.length - 1; ++t) {
                this.repaired[t] = this.original[this.prevNotNaN];
            }
        }
    }
}

