/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.drepair;

import org.apache.iotdb.library.drepair.util.TimestampRepair;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFTimestampRepair
implements UDTF {
    String intervalMethod;
    int interval;
    int intervalMode;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.DOUBLE, Type.FLOAT, Type.INT32, Type.INT64}).validate(x -> (Integer)x >= 0, "Interval should be a positive integer.", (Object)validator.getParameters().getIntOrDefault("interval", 0));
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy((AccessStrategy)new SlidingSizeWindowAccessStrategy(Integer.MAX_VALUE)).setOutputDataType(parameters.getDataType(0));
        this.intervalMethod = parameters.getStringOrDefault("method", "Median");
        this.interval = parameters.getIntOrDefault("interval", 0);
        if (this.interval > 0) {
            this.intervalMode = this.interval;
        } else if ("Median".equalsIgnoreCase(this.intervalMethod)) {
            this.intervalMode = -1;
        } else if ("Mode".equalsIgnoreCase(this.intervalMethod)) {
            this.intervalMode = -2;
        } else if ("Cluster".equalsIgnoreCase(this.intervalMethod)) {
            this.intervalMode = -3;
        } else {
            throw new UDFException("Illegal method.");
        }
    }

    public void transform(RowWindow rowWindow, PointCollector collector) throws Exception {
        TimestampRepair ts = new TimestampRepair(rowWindow.getRowIterator(), this.intervalMode, 2);
        ts.dpRepair();
        long[] timestamp = ts.getRepaired();
        double[] value = ts.getRepairedValue();
        switch (rowWindow.getDataType(0)) {
            case DOUBLE: {
                for (int i = 0; i < timestamp.length; ++i) {
                    collector.putDouble(timestamp[i], value[i]);
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < timestamp.length; ++i) {
                    collector.putFloat(timestamp[i], (float)value[i]);
                }
                break;
            }
            case INT32: {
                for (int i = 0; i < timestamp.length; ++i) {
                    collector.putInt(timestamp[i], (int)value[i]);
                }
                break;
            }
            case INT64: {
                for (int i = 0; i < timestamp.length; ++i) {
                    collector.putLong(timestamp[i], (long)value[i]);
                }
                break;
            }
            default: {
                throw new UDFException("");
            }
        }
    }
}

