/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile.util;

import java.util.Arrays;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularMatrixException;

public class YuleWalker {
    public double yuleWalker(double[] x, int order, String method, int n) {
        double adjNeeded = method.equalsIgnoreCase("adjusted") ? 1.0 : 0.0;
        double[] r = new double[order + 1];
        double squaresumx = 0.0;
        for (double v : x) {
            squaresumx += v * v;
        }
        r[0] = squaresumx / (double)n;
        for (int k = 1; k < order + 1; ++k) {
            double[] t1 = Arrays.copyOfRange(x, 0, n - k);
            double[] t2 = Arrays.copyOfRange(x, k, n);
            double crossmultiplysum = 0.0;
            for (int i = 0; i < Math.min(t1.length, t2.length); ++i) {
                crossmultiplysum += t1[i] * t2[i];
            }
            r[k] = crossmultiplysum / ((double)n - (double)k * adjNeeded);
        }
        double[][] r2d = new double[r.length - 1][r.length - 1];
        for (int i = 0; i < r.length - 1; ++i) {
            for (int j = 0; j < r.length - 1; ++j) {
                r2d[i][j] = r[Math.abs(i - j)];
            }
        }
        Array2DRowRealMatrix a = new Array2DRowRealMatrix(r2d, true);
        ArrayRealVector b = new ArrayRealVector(Arrays.copyOfRange(r, 1, r.length), true);
        DecompositionSolver solver = new LUDecomposition((RealMatrix)a).getSolver();
        try {
            RealVector rho = solver.solve((RealVector)b);
            return rho.getEntry(rho.getDimension() - 1);
        }
        catch (SingularMatrixException e) {
            return Double.NaN;
        }
    }
}

