/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.iotdb.library.util.LinearRegression;

public class Segment {
    private Segment() {
        throw new IllegalStateException("Utility class");
    }

    private static double calculateError(double[] y1, double[] y2) throws Exception {
        double[] y = ArrayUtils.addAll((double[])y1, (double[])y2);
        int l = y.length;
        double[] x = new double[l];
        for (int i = 0; i < l; ++i) {
            x[i] = i;
        }
        LinearRegression linearFit = new LinearRegression(x, y);
        return linearFit.getMAbsE();
    }

    public static List<double[]> bottomUp(double[] value, double maxError) throws Exception {
        int i;
        ArrayList<double[]> segTs = new ArrayList<double[]>();
        if (value.length <= 3) {
            ArrayList<double[]> ret = new ArrayList<double[]>();
            ret.add(value);
            return ret;
        }
        if (value.length % 2 == 0) {
            for (i = 0; i < value.length; i += 2) {
                segTs.add(Arrays.copyOfRange(value, i, i + 2));
            }
        } else {
            for (i = 0; i < value.length - 3; i += 2) {
                segTs.add(Arrays.copyOfRange(value, i, i + 2));
            }
            segTs.add(Arrays.copyOfRange(value, value.length - 3, value.length));
        }
        ArrayList<Double> mergeCost = new ArrayList<Double>();
        for (int i2 = 0; i2 < segTs.size() - 1; ++i2) {
            mergeCost.add(Segment.calculateError((double[])segTs.get(i2), (double[])segTs.get(i2 + 1)));
        }
        while ((Double)Collections.min(mergeCost) < maxError) {
            int index = mergeCost.indexOf(Collections.min(mergeCost));
            segTs.set(index, ArrayUtils.addAll((double[])((double[])segTs.get(index)), (double[])((double[])segTs.get(index + 1))));
            segTs.remove(index + 1);
            mergeCost.remove(index);
            if (segTs.size() == 1) break;
            if (index + 1 < segTs.size()) {
                mergeCost.set(index, Segment.calculateError((double[])segTs.get(index), (double[])segTs.get(index + 1)));
            }
            if (index <= 0) continue;
            mergeCost.set(index - 1, Segment.calculateError((double[])segTs.get(index - 1), (double[])segTs.get(index)));
        }
        return segTs;
    }

    private static double[] bestLine(double maxError, double[] inputDf, double[] w, int startIdx, double upperBound) throws Exception {
        double error = 0.0;
        int idx = startIdx + w.length;
        double[] sPrev = (double[])w.clone();
        if (idx >= inputDf.length) {
            return sPrev;
        }
        while (error <= maxError) {
            double[] s = ArrayUtils.addAll((double[])sPrev, (double[])new double[]{inputDf[idx]});
            ++idx;
            double[] times = new double[s.length];
            for (int i = 0; i < times.length; ++i) {
                times[i] = i;
            }
            error = new LinearRegression(times, s).getMAbsE();
            if (error <= maxError) {
                sPrev = (double[])s.clone();
            }
            if (!((double)sPrev.length > upperBound) && idx < inputDf.length) continue;
            break;
        }
        return sPrev;
    }

    public static double[] approximatedSegment(double[] inSeq) throws Exception {
        if (inSeq.length <= 2) {
            return inSeq;
        }
        double[] times = new double[inSeq.length];
        for (int i = 0; i < times.length; ++i) {
            times[i] = i;
        }
        return new LinearRegression(times, inSeq).getYhead();
    }

    private static List<double[]> swab(double[] inputDf, double maxError, int inWindowSize) throws Exception {
        int curNr = 0;
        int wNr = curNr + inWindowSize;
        int totSize = inputDf.length;
        double[] w = Arrays.copyOfRange(inputDf, curNr, wNr);
        int upperBound = 2 * wNr;
        ArrayList<double[]> segTs = new ArrayList<double[]>();
        boolean lastRun = false;
        while (true) {
            List<double[]> t = Segment.bottomUp(w, maxError);
            segTs.add(t.get(0));
            if (curNr >= totSize || lastRun) {
                if (t.size() <= 1) break;
                segTs.add(Segment.approximatedSegment(t.get(1)));
                break;
            }
            wNr = (curNr += t.get(0).length - 1) + inWindowSize;
            if (inputDf.length <= wNr) {
                lastRun = true;
                w = Arrays.copyOfRange(inputDf, curNr, inputDf.length);
            } else {
                w = Arrays.copyOfRange(inputDf, curNr, wNr);
            }
            Arrays.sort(w);
            if ((w = Segment.bestLine(maxError, inputDf, w, curNr, upperBound)).length <= upperBound) continue;
            w = Arrays.copyOfRange(w, 0, upperBound);
        }
        return segTs;
    }

    public static List<double[]> swabAlg(double[] df, double maxError, int windowsize) throws Exception {
        return Segment.swab(df, maxError, windowsize);
    }
}

