/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.iotdb.library.dprofile.util.Mad;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;

public class MADSketch {
    private long zeroCount;
    private double beta;
    private final double[] validRange;
    private final double alpha;
    private final double gamma;
    private final double multiplier;
    private final UnifiedMap<Integer, Long> positiveBuckets;
    private final UnifiedMap<Integer, Long> negativeBuckets;
    private static final double MIN_POSITIVE_VALUE = 1.0E-6;

    public MADSketch(double alpha) {
        this.alpha = alpha;
        this.gamma = 2.0 * alpha / (1.0 - alpha) + 1.0;
        this.multiplier = Math.log(Math.E) / Math.log1p(this.gamma - 1.0);
        this.beta = 1.0;
        this.positiveBuckets = new UnifiedMap();
        this.negativeBuckets = new UnifiedMap();
        this.zeroCount = 0L;
        this.validRange = new double[6];
    }

    public void insert(double v) {
        if (Double.isFinite(v)) {
            if (v > 1.0E-6) {
                int i = (int)Math.ceil(Math.log(v) * this.multiplier);
                this.positiveBuckets.put((Object)i, (Object)((Long)this.positiveBuckets.getOrDefault((Object)i, (Object)0L) + 1L));
            } else if (v < -1.0E-6) {
                int i = (int)Math.ceil(Math.log(-v) * this.multiplier);
                this.negativeBuckets.put((Object)i, (Object)((Long)this.negativeBuckets.getOrDefault((Object)i, (Object)0L) + 1L));
            } else {
                ++this.zeroCount;
            }
        }
    }

    public void insert(double v, double[] bounds) {
        if (v < bounds[0]) {
            v = bounds[0];
        } else if (v > bounds[1] && v < bounds[2]) {
            v = bounds[2];
        } else if (v > bounds[3] && v < bounds[4]) {
            v = bounds[4];
        } else if (v > bounds[5]) {
            v = bounds[5];
        }
        this.insert(v);
    }

    private Bucket[] unionBuckets() {
        Bucket[] buckets = new Bucket[this.sketchSize()];
        int i = 0;
        for (Map.Entry e : this.positiveBuckets.entrySet()) {
            buckets[i++] = new Bucket((Integer)e.getKey(), Math.pow(this.gamma, (double)((Integer)e.getKey()).intValue() - 1.0), Math.pow(this.gamma, ((Integer)e.getKey()).intValue()), (Long)e.getValue());
        }
        for (Map.Entry e : this.negativeBuckets.entrySet()) {
            buckets[i++] = new Bucket((Integer)e.getKey(), -Math.pow(this.gamma, ((Integer)e.getKey()).intValue()), -Math.pow(this.gamma, (double)((Integer)e.getKey()).intValue() - 1.0), (Long)e.getValue());
        }
        if (this.zeroCount > 0L) {
            buckets[i] = new Bucket(0, 0.0, 0.0, this.zeroCount);
        }
        Arrays.sort(buckets, Comparator.comparingDouble(o -> o.lowerBound));
        return buckets;
    }

    public long totalCount() {
        return this.positiveBuckets.values().stream().mapToLong(l -> l).sum() + this.negativeBuckets.values().stream().mapToLong(l -> l).sum() + this.zeroCount;
    }

    private int findPIndex(Bucket[] buckets, long totalCount) {
        long count = 0L;
        double rank = 0.5 * (double)(totalCount - 1L);
        for (int i = 0; i < buckets.length; ++i) {
            if (!((double)(count += buckets[i].count) > rank)) continue;
            return i;
        }
        return -1;
    }

    private int findQIndex(int p, Bucket[] buckets, long totalCount) {
        int q = p;
        long count = buckets[p].count;
        double rank = 0.5 * (double)(totalCount - 1L);
        int l = p - 1;
        int r = p + 1;
        while ((double)count <= rank && l >= 0 && r < buckets.length) {
            q = buckets[p].lowerBound - buckets[l].upperBound < buckets[r].lowerBound - buckets[p].upperBound ? l-- : r++;
            count += buckets[q].count;
        }
        while ((double)count <= rank && l >= 0) {
            q = l--;
            count += buckets[q].count;
        }
        while ((double)count <= rank && r < buckets.length) {
            q = r++;
            count += buckets[q].count;
        }
        double mLowerBound = buckets[p].lowerBound + buckets[p].upperBound - buckets[q].upperBound;
        double mUpperBound = buckets[p].lowerBound + buckets[p].upperBound - buckets[q].lowerBound;
        if (p > q) {
            --r;
            if (buckets[r].lowerBound <= mLowerBound && buckets[r].upperBound >= mUpperBound) {
                q = r;
            }
        } else if (p < q) {
            ++l;
            if (buckets[l].lowerBound <= mLowerBound && buckets[l].upperBound >= mUpperBound) {
                q = l;
            }
        }
        return q;
    }

    private void setValidRange(Bucket p, Bucket q) {
        this.validRange[0] = p.lowerBound;
        this.validRange[1] = p.upperBound;
        this.validRange[2] = p.lowerBound + q.lowerBound - p.upperBound;
        this.validRange[3] = p.upperBound + q.upperBound - p.lowerBound;
        this.validRange[4] = 2.0 * p.lowerBound - q.upperBound;
        this.validRange[5] = 2.0 * p.upperBound - q.lowerBound;
        Arrays.sort(this.validRange);
    }

    private double minDelta(double delta1, double delta2) {
        double delta = delta1 < 0.0 && delta2 < 0.0 ? 0.0 : (delta1 < 0.0 ? delta2 : (delta2 < 0.0 ? delta1 : Math.min(delta1, delta2)));
        return delta;
    }

    public Mad getMad() {
        long totalCount;
        this.beta = 1.0;
        Bucket[] buckets = this.unionBuckets();
        int pIndex = this.findPIndex(buckets, totalCount = this.totalCount());
        if (pIndex == -1) {
            throw new NoSuchElementException("No values in the time series");
        }
        int qIndex = this.findQIndex(pIndex, buckets, totalCount);
        Bucket p = buckets[pIndex];
        Bucket q = buckets[qIndex];
        if (p.lowerBound * q.lowerBound > 0.0) {
            if (p.lowerBound == q.lowerBound) {
                return new Mad(0.0, Double.MAX_VALUE);
            }
            double mad = 2.0 * (p.upperBound - q.lowerBound) * (p.lowerBound - q.upperBound) / ((this.gamma + 1.0) * Math.abs(p.lowerBound - q.lowerBound));
            double gammaPQ = Math.max(p.upperBound / q.upperBound, q.upperBound / p.upperBound);
            double delta = Math.abs(p.lowerBound) < Math.abs(q.lowerBound) ? this.minDelta(gammaPQ / Math.pow(this.gamma, 2.0) - 1.0 / this.gamma + Math.pow(this.gamma, -3.0), 1.0 / (Math.pow(this.gamma, 3.0) - gammaPQ * this.gamma + Math.pow(this.gamma, 2.0))) : this.minDelta(Math.pow(this.gamma, -2.0) + Math.pow(this.gamma, -3.0) - 1.0 / (gammaPQ * this.gamma), 1.0 / (Math.pow(this.gamma, 2.0) / gammaPQ + Math.pow(this.gamma, 3.0) - this.gamma));
            this.beta = 1.0 - 2.0 / (1.0 + delta);
            if (this.needTwoPass()) {
                this.setValidRange(p, q);
                return new Mad(mad, (1.0 + 2.0 / (gammaPQ - 1.0)) * this.alpha);
            }
            return new Mad(0.0, Double.MAX_VALUE);
        }
        double mad = 2.0 * Math.max(Math.abs(p.upperBound - q.lowerBound), Math.abs(q.upperBound - p.lowerBound)) / (this.gamma + 1.0);
        return new Mad(mad, this.alpha);
    }

    public int sketchSize() {
        return this.positiveBuckets.size() + this.negativeBuckets.size() + (this.zeroCount == 0L ? 0 : 1);
    }

    public boolean needTwoPass() {
        return this.beta > 0.0 && this.beta < 1.0;
    }

    public double getBeta() {
        return this.beta;
    }

    public double[] getValidRange() {
        return this.validRange;
    }

    public double getAlpha() {
        return this.alpha;
    }

    private static class Bucket {
        int index;
        double lowerBound;
        double upperBound;
        long count;

        Bucket(int index, double lowerBound, double upperBound, long count) {
            this.index = index;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.count = count;
        }
    }
}

