/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile.util;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.udf.api.type.Type;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;

public class ExactOrderStatistics {
    private final Type dataType;
    private FloatArrayList floatArrayList;
    private DoubleArrayList doubleArrayList;
    private IntArrayList intArrayList;
    private LongArrayList longArrayList;

    public ExactOrderStatistics(Type type) throws UDFInputSeriesDataTypeNotValidException {
        this.dataType = type;
        switch (this.dataType) {
            case INT32: {
                this.intArrayList = new IntArrayList();
                break;
            }
            case INT64: {
                this.longArrayList = new LongArrayList();
                break;
            }
            case FLOAT: {
                this.floatArrayList = new FloatArrayList();
                break;
            }
            case DOUBLE: {
                this.doubleArrayList = new DoubleArrayList();
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, this.dataType, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
            }
        }
    }

    public void insert(Row row) throws UDFInputSeriesDataTypeNotValidException, IOException {
        switch (this.dataType) {
            case INT32: {
                this.intArrayList.add(row.getInt(0));
                break;
            }
            case INT64: {
                this.longArrayList.add(row.getLong(0));
                break;
            }
            case FLOAT: {
                float vf = row.getFloat(0);
                if (!Float.isFinite(vf)) break;
                this.floatArrayList.add(vf);
                break;
            }
            case DOUBLE: {
                double vd = row.getDouble(0);
                if (!Double.isFinite(vd)) break;
                this.doubleArrayList.add(vd);
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, this.dataType, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
            }
        }
    }

    public double getMedian() throws UDFInputSeriesDataTypeNotValidException {
        switch (this.dataType) {
            case INT32: {
                return ExactOrderStatistics.getMedian(this.intArrayList);
            }
            case INT64: {
                return ExactOrderStatistics.getMedian(this.longArrayList);
            }
            case FLOAT: {
                return ExactOrderStatistics.getMedian(this.floatArrayList);
            }
            case DOUBLE: {
                return ExactOrderStatistics.getMedian(this.doubleArrayList);
            }
        }
        throw new UDFInputSeriesDataTypeNotValidException(0, this.dataType, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
    }

    public static double getMedian(FloatArrayList nums) {
        if (nums.isEmpty()) {
            throw new NoSuchElementException();
        }
        nums.sortThis();
        if (nums.size() % 2 == 0) {
            return (double)(nums.get(nums.size() / 2) + nums.get(nums.size() / 2 - 1)) / 2.0;
        }
        return nums.get((nums.size() - 1) / 2);
    }

    public static double getMedian(DoubleArrayList nums) {
        if (nums.isEmpty()) {
            throw new NoSuchElementException();
        }
        nums.sortThis();
        if (nums.size() % 2 == 0) {
            return (nums.get(nums.size() / 2) + nums.get(nums.size() / 2 - 1)) / 2.0;
        }
        return nums.get((nums.size() - 1) / 2);
    }

    public static double getMedian(IntArrayList nums) {
        if (nums.isEmpty()) {
            throw new NoSuchElementException();
        }
        nums.sortThis();
        if (nums.size() % 2 == 0) {
            return (double)(nums.get(nums.size() / 2) + nums.get(nums.size() / 2 - 1)) / 2.0;
        }
        return nums.get((nums.size() - 1) / 2);
    }

    public static double getMedian(LongArrayList nums) {
        if (nums.isEmpty()) {
            throw new NoSuchElementException();
        }
        nums.sortThis();
        if (nums.size() % 2 == 0) {
            return (double)(nums.get(nums.size() / 2) + nums.get(nums.size() / 2 - 1)) / 2.0;
        }
        return nums.get((nums.size() - 1) / 2);
    }

    public static double getMad(FloatArrayList nums) {
        if (nums.isEmpty()) {
            throw new NoSuchElementException();
        }
        double median = ExactOrderStatistics.getMedian(nums);
        DoubleArrayList dal = new DoubleArrayList();
        for (int i = 0; i < nums.size(); ++i) {
            dal.set(i, Math.abs((double)nums.get(i) - median));
        }
        return ExactOrderStatistics.getMedian(dal);
    }

    public double getMad() throws UDFInputSeriesDataTypeNotValidException {
        switch (this.dataType) {
            case INT32: {
                return ExactOrderStatistics.getMad(this.intArrayList);
            }
            case INT64: {
                return ExactOrderStatistics.getMad(this.longArrayList);
            }
            case FLOAT: {
                return ExactOrderStatistics.getMad(this.floatArrayList);
            }
            case DOUBLE: {
                return ExactOrderStatistics.getMad(this.doubleArrayList);
            }
        }
        throw new UDFInputSeriesDataTypeNotValidException(0, this.dataType, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
    }

    public static double getMad(DoubleArrayList nums) {
        if (nums.isEmpty()) {
            throw new NoSuchElementException();
        }
        double median = ExactOrderStatistics.getMedian(nums);
        DoubleArrayList dal = new DoubleArrayList();
        for (int i = 0; i < nums.size(); ++i) {
            dal.set(i, Math.abs(nums.get(i) - median));
        }
        return ExactOrderStatistics.getMedian(dal);
    }

    public static double getMad(IntArrayList nums) {
        if (nums.isEmpty()) {
            throw new NoSuchElementException();
        }
        double median = ExactOrderStatistics.getMedian(nums);
        DoubleArrayList dal = new DoubleArrayList();
        for (int i = 0; i < nums.size(); ++i) {
            dal.set(i, Math.abs((double)nums.get(i) - median));
        }
        return ExactOrderStatistics.getMedian(dal);
    }

    public static double getMad(LongArrayList nums) {
        if (nums.isEmpty()) {
            throw new NoSuchElementException();
        }
        double median = ExactOrderStatistics.getMedian(nums);
        DoubleArrayList dal = new DoubleArrayList();
        for (int i = 0; i < nums.size(); ++i) {
            dal.set(i, Math.abs((double)nums.get(i) - median));
        }
        return ExactOrderStatistics.getMedian(dal);
    }

    public static float getPercentile(FloatArrayList nums, double phi) {
        if (nums.isEmpty()) {
            throw new NoSuchElementException();
        }
        nums.sortThis();
        return nums.get((int)Math.ceil((double)nums.size() * phi));
    }

    public static double getPercentile(DoubleArrayList nums, double phi) {
        if (nums.isEmpty()) {
            throw new NoSuchElementException();
        }
        nums.sortThis();
        return nums.get((int)Math.ceil((double)nums.size() * phi));
    }

    public String getPercentile(double phi) throws UDFInputSeriesDataTypeNotValidException {
        switch (this.dataType) {
            case INT32: {
                return Integer.toString(ExactOrderStatistics.getPercentile(this.intArrayList, phi));
            }
            case INT64: {
                return Long.toString(ExactOrderStatistics.getPercentile(this.longArrayList, phi));
            }
            case FLOAT: {
                return Float.toString(ExactOrderStatistics.getPercentile(this.floatArrayList, phi));
            }
            case DOUBLE: {
                return Double.toString(ExactOrderStatistics.getPercentile(this.doubleArrayList, phi));
            }
        }
        throw new UDFInputSeriesDataTypeNotValidException(0, this.dataType, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
    }

    public static int getPercentile(IntArrayList nums, double phi) {
        if (nums.isEmpty()) {
            throw new NoSuchElementException();
        }
        nums.sortThis();
        return nums.get((int)Math.ceil((double)nums.size() * phi));
    }

    public static long getPercentile(LongArrayList nums, double phi) {
        if (nums.isEmpty()) {
            throw new NoSuchElementException();
        }
        nums.sortThis();
        return nums.get((int)Math.ceil((double)nums.size() * phi));
    }
}

