/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile.util;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

class Bucket<T extends Pair<Long, Double>> {
    private final List<T> data;
    private final T first;
    private final T last;
    private final Pair<Long, Double> center;
    private final T result;

    private Bucket(List<T> data, T first, T last, Pair<Long, Double> center, T result) {
        this.data = data;
        this.first = first;
        this.last = last;
        this.center = center;
        this.result = result;
    }

    static <U extends Pair<Long, Double>> Bucket<U> of(List<U> us) {
        Pair first = (Pair)us.get(0);
        Pair last = (Pair)us.get(us.size() - 1);
        Pair<Long, Double> center = Bucket.centerBetween((Pair<Long, Double>)first, (Pair<Long, Double>)last);
        return new Bucket<Pair>(us, first, last, center, first);
    }

    static <U extends Pair<Long, Double>> Bucket<U> of(U u) {
        return new Bucket<U>(Collections.singletonList(u), u, u, u, u);
    }

    T getResult() {
        return this.result;
    }

    T getFirst() {
        return this.first;
    }

    T getLast() {
        return this.last;
    }

    Pair<Long, Double> getCenter() {
        return this.center;
    }

    <U> List<U> map(Function<T, U> mapper) {
        return this.data.stream().map(mapper).collect(Collectors.toList());
    }

    static Pair<Long, Double> centerBetween(Pair<Long, Double> a, Pair<Long, Double> b) {
        Pair vector = Pair.of((Object)((Long)b.getLeft() - (Long)a.getLeft()), (Object)((Double)b.getRight() - (Double)a.getRight()));
        Pair halfVector = Pair.of((Object)((Long)vector.getLeft() / 2L), (Object)((Double)vector.getRight() / 2.0));
        return Pair.of((Object)((Long)a.getLeft() + (Long)halfVector.getLeft()), (Object)((Double)a.getRight() + (Double)halfVector.getRight()));
    }
}

