/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.analysis.interpolation.AkimaSplineInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFSpline
implements UDTF {
    AkimaSplineInterpolator asi;
    int samplePoints;
    ArrayList<Long> timestamp = new ArrayList();
    ArrayList<Double> yDouble = new ArrayList();
    ArrayList<Double> xDouble = new ArrayList();
    Long minimumTimestamp = -1L;
    PolynomialSplineFunction psf;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.FLOAT, Type.DOUBLE, Type.INT32, Type.INT64});
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        this.samplePoints = parameters.getInt("points");
        this.timestamp.clear();
        this.xDouble.clear();
        this.yDouble.clear();
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        double v = Util.getValueAsDouble(row);
        if (Double.isFinite(v)) {
            Long t = row.getTime();
            if (this.minimumTimestamp < 0L) {
                this.minimumTimestamp = t;
            }
            this.timestamp.add(t);
            this.xDouble.add(Double.valueOf(Long.toString(t - this.minimumTimestamp)));
            this.yDouble.add(Util.getValueAsDouble(row));
        }
    }

    public void terminate(PointCollector collector) throws Exception {
        if (this.yDouble.size() >= 4 && this.samplePoints >= 2) {
            this.asi = new AkimaSplineInterpolator();
            double[] x = ArrayUtils.toPrimitive((Double[])this.xDouble.toArray(new Double[0]));
            double[] y = ArrayUtils.toPrimitive((Double[])this.yDouble.toArray(new Double[0]));
            this.psf = this.asi.interpolate(x, y);
            for (int i = 0; i < this.samplePoints; ++i) {
                int approximation = (int)Math.floor((x[0] * (double)(this.samplePoints - 1 - i) + x[this.yDouble.size() - 1] * (double)i) / (double)(this.samplePoints - 1) + 0.5);
                double yhead = this.psf.value((double)approximation);
                collector.putDouble(this.minimumTimestamp + (long)approximation, yhead);
            }
        }
    }
}

