/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile;

import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;

public class UDTFQLB
implements UDTF {
    private final DoubleArrayList valueArrayList = new DoubleArrayList();
    private int m = 0;
    private double qlb = 0.0;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE}).validate(x -> (Integer)x >= 0, "Parameter $lag$ should be an positive integer, or '0' for default value.", (Object)validator.getParameters().getIntOrDefault("lag", 0));
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        this.m = parameters.getIntOrDefault("lag", 0);
        this.valueArrayList.clear();
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        if (row.isNull(0)) {
            this.valueArrayList.add(Double.NaN);
        } else {
            double v = Util.getValueAsDouble(row);
            if (Double.isFinite(v)) {
                this.valueArrayList.add(v);
            } else {
                this.valueArrayList.add(0.0);
            }
        }
    }

    public void terminate(PointCollector collector) throws Exception {
        int n = this.valueArrayList.size();
        if (this.m <= 0 || this.m >= n) {
            this.m = n - 2;
        }
        for (int shift = 1; shift <= this.m; ++shift) {
            double correlation = 0.0;
            for (int i = 0; i < n - shift; ++i) {
                if (!Double.isFinite(this.valueArrayList.get(shift + i)) || !Double.isFinite(this.valueArrayList.get(i))) continue;
                correlation += this.valueArrayList.get(shift + i) * this.valueArrayList.get(i);
            }
            collector.putDouble((long)n + (long)shift, correlation /= (double)n);
            this.qlb += correlation * correlation / (double)(n - shift) * (double)n * (double)(n + 2);
            ChiSquaredDistribution qlbdist = new ChiSquaredDistribution((double)shift);
            double qlbprob = 1.0 - qlbdist.cumulativeProbability(this.qlb);
            collector.putDouble((long)shift, qlbprob);
        }
    }

    public void beforeDestroy() {
        this.valueArrayList.clear();
    }
}

