/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile;

import java.util.HashSet;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;
import org.eclipse.collections.api.iterator.MutableBooleanIterator;
import org.eclipse.collections.api.iterator.MutableDoubleIterator;
import org.eclipse.collections.api.iterator.MutableFloatIterator;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.impl.set.mutable.primitive.BooleanHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;

public class UDTFDistinct
implements UDTF {
    private IntHashSet intSet;
    private LongHashSet longSet;
    private FloatHashSet floatSet;
    private DoubleHashSet doubleSet;
    private BooleanHashSet booleanSet;
    private HashSet<String> stringSet;
    private Type dataType;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE, Type.TEXT, Type.BOOLEAN});
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy()).setOutputDataType(parameters.getDataType(0));
        this.dataType = parameters.getDataType(0);
        switch (this.dataType) {
            case INT32: {
                this.intSet = new IntHashSet();
                break;
            }
            case INT64: {
                this.longSet = new LongHashSet();
                break;
            }
            case FLOAT: {
                this.floatSet = new FloatHashSet();
                break;
            }
            case DOUBLE: {
                this.doubleSet = new DoubleHashSet();
                break;
            }
            case TEXT: {
                this.stringSet = new HashSet();
                break;
            }
            case BOOLEAN: {
                this.booleanSet = new BooleanHashSet();
                break;
            }
        }
    }

    public void transform(Row row, PointCollector pc) throws Exception {
        switch (this.dataType) {
            case INT32: {
                this.intSet.add(row.getInt(0));
                break;
            }
            case INT64: {
                this.longSet.add(row.getLong(0));
                break;
            }
            case FLOAT: {
                this.floatSet.add(row.getFloat(0));
                break;
            }
            case DOUBLE: {
                this.doubleSet.add(row.getDouble(0));
                break;
            }
            case TEXT: {
                this.stringSet.add(row.getString(0));
                break;
            }
            case BOOLEAN: {
                this.booleanSet.add(row.getBoolean(0));
                break;
            }
        }
    }

    public void terminate(PointCollector pc) throws Exception {
        int i = 0;
        switch (this.dataType) {
            case INT32: {
                MutableIntIterator intIterator = this.intSet.intIterator();
                while (intIterator.hasNext()) {
                    pc.putInt((long)i, intIterator.next());
                    ++i;
                }
                break;
            }
            case INT64: {
                MutableLongIterator longIterator = this.longSet.longIterator();
                while (longIterator.hasNext()) {
                    pc.putLong((long)i, longIterator.next());
                    ++i;
                }
                break;
            }
            case FLOAT: {
                MutableFloatIterator floatIterator = this.floatSet.floatIterator();
                while (floatIterator.hasNext()) {
                    pc.putFloat((long)i, floatIterator.next());
                    ++i;
                }
                break;
            }
            case DOUBLE: {
                MutableDoubleIterator doubleIterator = this.doubleSet.doubleIterator();
                while (doubleIterator.hasNext()) {
                    pc.putDouble((long)i, doubleIterator.next());
                    ++i;
                }
                break;
            }
            case TEXT: {
                for (String s : this.stringSet) {
                    pc.putString((long)i, s);
                    ++i;
                }
                break;
            }
            case BOOLEAN: {
                MutableBooleanIterator booleanIterator = this.booleanSet.booleanIterator();
                while (booleanIterator.hasNext()) {
                    pc.putBoolean((long)i, booleanIterator.next());
                    ++i;
                }
                break;
            }
        }
    }

    public void beforeDestroy() {
        switch (this.dataType) {
            case INT32: {
                this.intSet.clear();
                break;
            }
            case INT64: {
                this.longSet.clear();
                break;
            }
            case FLOAT: {
                this.floatSet.clear();
                break;
            }
            case DOUBLE: {
                this.doubleSet.clear();
                break;
            }
            case TEXT: {
                this.stringSet.clear();
                break;
            }
            case BOOLEAN: {
                this.booleanSet.clear();
                break;
            }
        }
    }
}

