/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile;

import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDAFSkew
implements UDTF {
    private long count = 0L;
    private double sumX3 = 0.0;
    private double sumX2 = 0.0;
    private double sumX1 = 0.0;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        double value = Util.getValueAsDouble(row);
        if (Double.isFinite(value)) {
            ++this.count;
            this.sumX1 += value;
            this.sumX2 += value * value;
            this.sumX3 += value * value * value;
        }
    }

    public void terminate(PointCollector collector) throws Exception {
        collector.putDouble(0L, (this.sumX3 / (double)this.count - 3.0 * this.sumX1 / (double)this.count * this.sumX2 / (double)this.count + 2.0 * Math.pow(this.sumX1 / (double)this.count, 3.0)) / Math.pow(this.sumX2 / (double)this.count - this.sumX1 / (double)this.count * this.sumX1 / (double)this.count, 1.5));
    }
}

