/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile;

import org.apache.commons.math3.util.Pair;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.access.RowIterator;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;

public class UDAFPeriod
implements UDTF {
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.FLOAT, Type.DOUBLE, Type.INT32, Type.INT64});
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy((AccessStrategy)new SlidingSizeWindowAccessStrategy(Integer.MAX_VALUE)).setOutputDataType(Type.INT32);
    }

    public void transform(RowWindow rowWindow, PointCollector collector) throws Exception {
        DoubleArrayList value = new DoubleArrayList();
        RowIterator iterator = rowWindow.getRowIterator();
        while (iterator.hasNextRow()) {
            Row row = iterator.next();
            double v = Util.getValueAsDouble(row);
            if (Double.isFinite(v)) {
                value.add(v);
                continue;
            }
            value.add(value.getLast());
        }
        double[] corr = this.autoCorrelation(value.toArray());
        int[] peeks = this.findPeeks(corr).toArray();
        int period = 0;
        if (peeks.length > 1) {
            int[] gap = Util.variation(peeks);
            period = (int)new IntArrayList(gap).median();
        }
        collector.putInt(0L, period);
    }

    private IntArrayList findPeeks(double[] x) {
        int i;
        int window = 100;
        IntArrayList peeks = new IntArrayList();
        peeks.add(0);
        double threshold = 0.5;
        for (i = 1; i < Math.min(x.length - 1, window); ++i) {
            if (!(x[i] > x[i - 1]) || !(x[i] > x[i + 1]) || !(x[i] > threshold)) continue;
            window = i;
            break;
        }
        i = 0;
        while (i + window <= x.length) {
            Pair<Double, Integer> p;
            double v = x[i + window / 2];
            if (v > threshold && (Integer)(p = this.max(x, i, i + window)).getSecond() == i + window / 2) {
                peeks.add(((Integer)p.getSecond()).intValue());
            }
            ++i;
        }
        return peeks;
    }

    private Pair<Double, Integer> max(double[] x, int startIndex, int endIndex) {
        double maxValue = -1.7976931348623157E308;
        int maxIndex = -1;
        for (int i = startIndex; i < endIndex; ++i) {
            if (!(x[i] > maxValue)) continue;
            maxValue = x[i];
            maxIndex = i;
        }
        return Pair.create((Object)x[maxIndex], (Object)maxIndex);
    }

    private double[] autoCorrelation(double[] x) {
        double[] corr = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            corr[i] = this.pearson(x, x.length - i);
        }
        return corr;
    }

    private double pearson(double[] x, int subLength) {
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXX = 0.0;
        double sumYY = 0.0;
        double sumXY = 0.0;
        int s1 = 0;
        int s2 = x.length - subLength;
        for (int i = 0; i < subLength; ++i) {
            sumX += x[s1 + i];
            sumY += x[s2 + i];
            sumXX += x[s1 + i] * x[s1 + i];
            sumYY += x[s2 + i] * x[s2 + i];
            sumXY += x[s1 + i] * x[s2 + i];
        }
        return ((double)subLength * sumXY - sumX * sumY) / Math.sqrt((double)subLength * sumXX - sumX * sumX) / Math.sqrt((double)subLength * sumYY - sumY * sumY);
    }
}

