/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile;

import org.apache.iotdb.library.dprofile.util.ExactOrderStatistics;
import org.apache.iotdb.library.dprofile.util.MADSketch;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDAFMad
implements UDTF {
    private ExactOrderStatistics statistics;
    private MADSketch sketch;
    private boolean exact;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE}).validate(error -> (Double)error >= 0.0 && (Double)error < 1.0, "error has to be greater than or equal to 0 and less than 1.", (Object)validator.getParameters().getDoubleOrDefault("error", 0.0));
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        double error = parameters.getDoubleOrDefault("error", 0.0);
        boolean bl = this.exact = error == 0.0;
        if (this.exact) {
            this.statistics = new ExactOrderStatistics(parameters.getDataType(0));
        } else {
            this.sketch = new MADSketch(error);
        }
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        if (this.exact) {
            this.statistics.insert(row);
        } else {
            this.sketch.insert(Util.getValueAsDouble(row));
        }
    }

    public void terminate(PointCollector collector) throws Exception {
        if (this.exact) {
            collector.putDouble(0L, this.statistics.getMad());
        } else {
            collector.putDouble(0L, this.sketch.getMad().result);
        }
    }
}

