/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile;

import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDAFIntegralAvg
implements UDTF {
    long startTime = -1L;
    long lastTime = -1L;
    double lastValue = 0.0;
    double integralValue = 0.0;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        long nowTime = row.getTime();
        double nowValue = Util.getValueAsDouble(row);
        if (this.startTime < 0L) {
            this.startTime = nowTime;
        }
        if (Double.isFinite(nowValue)) {
            if (this.lastTime >= 0L) {
                this.integralValue += (this.lastValue + nowValue) * (double)(nowTime - this.lastTime) / 2.0;
            }
            this.lastTime = nowTime;
            this.lastValue = nowValue;
        }
    }

    public void terminate(PointCollector collector) throws Exception {
        if (this.startTime < 0L) {
            collector.putDouble(0L, 0.0);
        } else if (this.startTime == this.lastTime) {
            collector.putDouble(0L, this.lastValue);
        } else {
            collector.putDouble(0L, this.integralValue / (double)(this.lastTime - this.startTime));
        }
    }
}

