/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dmatch;

import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;

public class UDTFPtnSym
implements UDTF {
    private int window;
    private double threshold;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE}).validate(x -> (Integer)x > 0, "window has to be a positive integer.", (Object)validator.getParameters().getIntOrDefault("window", 10)).validate(x -> (Double)x >= 0.0, "threshold has to be non-negative.", (Object)validator.getParameters().getDoubleOrDefault("threshold", Double.MAX_VALUE));
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        this.window = parameters.getIntOrDefault("window", 10);
        configurations.setAccessStrategy((AccessStrategy)new SlidingSizeWindowAccessStrategy(this.window, 1)).setOutputDataType(Type.DOUBLE);
        this.threshold = parameters.getDoubleOrDefault("threshold", Double.MAX_VALUE);
    }

    public void transform(RowWindow rowWindow, PointCollector collector) throws Exception {
        if (rowWindow.windowSize() < this.window) {
            return;
        }
        DoubleArrayList a = new DoubleArrayList();
        int n = rowWindow.windowSize();
        long time = rowWindow.getRow(0).getTime();
        for (int i = 0; i < n; ++i) {
            Row row = rowWindow.getRow(i);
            a.add(Util.getValueAsDouble(row, 0));
        }
        int m = a.size();
        double[][] dp = new double[m + 1][m + 1];
        for (int i = 1; i <= m; ++i) {
            dp[i][i] = 0.0;
            if (i >= m) continue;
            dp[i][i + 1] = Math.pow(Math.abs(a.get(i - 1) - a.get(i)), 2.0);
        }
        for (int len = 3; len <= m; ++len) {
            int i = 1;
            for (int j = len; j <= m; ++j) {
                dp[i][j] = Math.pow(Math.abs(a.get(0) - a.get(j - 1)), 2.0) + Math.min(Math.min(dp[i + 1][j], dp[i][j - 1]), dp[i + 1][j - 1]);
            }
        }
        if (dp[1][m] <= this.threshold) {
            collector.putDouble(time, dp[1][m]);
        }
    }
}

