/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dmatch;

import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDAFPearson
implements UDTF {
    private long count = 0L;
    private double sumX = 0.0;
    private double sumY = 0.0;
    private double sumXY = 0.0;
    private double sumXX = 0.0;
    private double sumYY = 0.0;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(2).validateInputSeriesDataType(0, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE}).validateInputSeriesDataType(1, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        this.count = 0L;
        this.sumX = 0.0;
        this.sumY = 0.0;
        this.sumXY = 0.0;
        this.sumXX = 0.0;
        this.sumYY = 0.0;
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        if (row.isNull(0) || row.isNull(1)) {
            return;
        }
        double x = Util.getValueAsDouble(row, 0);
        double y = Util.getValueAsDouble(row, 1);
        if (Double.isFinite(x) && Double.isFinite(y)) {
            ++this.count;
            this.sumX += x;
            this.sumY += y;
            this.sumXY += x * y;
            this.sumXX += x * x;
            this.sumYY += y * y;
        }
    }

    public void terminate(PointCollector collector) throws Exception {
        if (this.count > 0L) {
            double pearson = ((double)this.count * this.sumXY - this.sumX * this.sumY) / Math.sqrt((double)this.count * this.sumXX - this.sumX * this.sumX) / Math.sqrt((double)this.count * this.sumYY - this.sumY * this.sumY);
            collector.putDouble(0L, pearson);
        } else {
            collector.putDouble(0L, Double.NaN);
        }
    }
}

