/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.anomaly;

import org.apache.iotdb.library.anomaly.util.WindowDetect;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFTwoSidedFilter
implements UDTF {
    private double len;
    private double threshold;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy((AccessStrategy)new SlidingSizeWindowAccessStrategy(Integer.MAX_VALUE)).setOutputDataType(parameters.getDataType(0));
        this.len = parameters.getDoubleOrDefault("len", 5.0);
        this.threshold = parameters.getDoubleOrDefault("threshold", 0.4);
    }

    public void transform(RowWindow rowWindow, PointCollector collector) throws Exception {
        WindowDetect wd = new WindowDetect(rowWindow.getRowIterator(), this.len, this.threshold);
        double[] repaired = wd.getRepaired();
        long[] time = wd.getTime();
        switch (rowWindow.getDataType(0)) {
            case DOUBLE: {
                for (int i = 0; i < time.length; ++i) {
                    collector.putDouble(time[i], repaired[i]);
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < time.length; ++i) {
                    collector.putFloat(time[i], (float)repaired[i]);
                }
                break;
            }
            case INT32: {
                for (int i = 0; i < time.length; ++i) {
                    collector.putInt(time[i], (int)Math.round(repaired[i]));
                }
                break;
            }
            case INT64: {
                for (int i = 0; i < time.length; ++i) {
                    collector.putLong(time[i], Math.round(repaired[i]));
                }
                break;
            }
            default: {
                throw new UDFException("No such kind of data type.");
            }
        }
    }

    public void terminate(PointCollector collector) throws Exception {
    }
}

