/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.anomaly;

import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFRange
implements UDTF {
    private Type dataType;
    private double upperBound;
    private double lowerBound;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy()).setOutputDataType(parameters.getDataType(0));
        this.lowerBound = parameters.getDouble("lower_bound");
        this.upperBound = parameters.getDouble("upper_bound");
        this.dataType = parameters.getDataType(0);
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        long timestamp = row.getTime();
        switch (this.dataType) {
            case INT32: {
                int intValue = row.getInt(0);
                if (!((double)intValue > this.upperBound) && !((double)intValue < this.lowerBound)) break;
                collector.putInt(timestamp, intValue);
                break;
            }
            case INT64: {
                long longValue = row.getLong(0);
                if (!((double)longValue > this.upperBound) && !((double)longValue < this.lowerBound)) break;
                collector.putLong(timestamp, longValue);
                break;
            }
            case FLOAT: {
                float floatValue = row.getFloat(0);
                if (!((double)floatValue > this.upperBound) && !((double)floatValue < this.lowerBound)) break;
                collector.putFloat(timestamp, floatValue);
                break;
            }
            case DOUBLE: {
                double doubleValue = row.getDouble(0);
                if (!(doubleValue > this.upperBound) && !(doubleValue < this.lowerBound)) break;
                collector.putDouble(timestamp, doubleValue);
                break;
            }
            default: {
                throw new UDFException("No such kind of data type.");
            }
        }
    }

    public void terminate(PointCollector collector) throws Exception {
    }
}

