/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.anomaly;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFOutlier
implements UDTF {
    private int k;
    private double r;
    private int w;
    private int s;
    private int i;
    private ArrayList<Long> currentTimeWindow = new ArrayList();
    private ArrayList<Double> currentValueWindow = new ArrayList();
    private Map<Long, Double> outliers = new HashMap<Long, Double>();

    public void beforeStart(UDFParameters udfParameters, UDTFConfigurations udtfConfigurations) throws Exception {
        udtfConfigurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy()).setOutputDataType(udfParameters.getDataType(0));
        this.k = udfParameters.getIntOrDefault("k", 3);
        this.r = udfParameters.getDoubleOrDefault("r", 5.0);
        this.w = udfParameters.getIntOrDefault("w", 1000);
        this.s = udfParameters.getIntOrDefault("s", 500);
        this.i = 0;
        udtfConfigurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy());
        udtfConfigurations.setOutputDataType(Type.DOUBLE);
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        if (!row.isNull(0)) {
            if (this.i >= this.w && (this.i - this.w) % this.s == 0) {
                this.detect();
            }
            if (this.i >= this.w) {
                this.currentValueWindow.remove(0);
                this.currentTimeWindow.remove(0);
            }
            this.currentTimeWindow.add(row.getTime());
            this.currentValueWindow.add(Util.getValueAsDouble(row));
            ++this.i;
        }
    }

    public void terminate(PointCollector collector) throws Exception {
        for (Long time : this.outliers.keySet().stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList())) {
            collector.putDouble(time.longValue(), this.outliers.get(time).doubleValue());
        }
    }

    private void detect() {
        for (int j = 0; j < this.w; ++j) {
            int cnt = 0;
            for (int l = 0; l < this.w; ++l) {
                if (!(Math.abs(this.currentValueWindow.get(j) - this.currentValueWindow.get(l)) <= this.r)) continue;
                ++cnt;
            }
            if (cnt >= this.k || this.outliers.keySet().contains(this.currentTimeWindow.get(j))) continue;
            this.outliers.put(this.currentTimeWindow.get(j), this.currentValueWindow.get(j));
        }
    }
}

