/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.anomaly;

import org.apache.iotdb.library.anomaly.util.StreamMissDetector;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFMissDetect
implements UDTF {
    private StreamMissDetector detector;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.DOUBLE, Type.FLOAT, Type.INT32, Type.INT64}).validate(x -> (Integer)x >= 10, "minlen should be an integer greater than or equal to 10.", (Object)validator.getParameters().getIntOrDefault("minlen", 10));
    }

    public void beforeStart(UDFParameters udfp, UDTFConfigurations udtfc) throws Exception {
        udtfc.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy()).setOutputDataType(Type.BOOLEAN);
        int minLength = udfp.getIntOrDefault("minlen", 10);
        this.detector = new StreamMissDetector(minLength);
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        this.detector.insert(row.getTime(), Util.getValueAsDouble(row));
        while (this.detector.hasNext()) {
            collector.putBoolean(this.detector.getOutTime(), this.detector.getOutValue());
            this.detector.next();
        }
    }

    public void terminate(PointCollector collector) throws Exception {
        this.detector.flush();
        while (this.detector.hasNext()) {
            collector.putBoolean(this.detector.getOutTime(), this.detector.getOutValue());
            this.detector.next();
        }
    }
}

